/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	SceneManager
**
** DESCRIPTION:	Manages drawing priority of scene elements
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SCENE_MANAGER_H
#define SCENE_MANAGER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ldwImage.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int SceneManager_c_iMaxElements = 1024;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum ESceneElement
{
	eSceneElement_None,

	eSceneElement_Bird,
	eSceneElement_CollectableItem,
	eSceneElement_Environment,
	eSceneElement_FloatingAnim,
	eSceneElement_Graveyard,
	eSceneElement_Puzzle,
	eSceneElement_Shark,
	eSceneElement_Villager,
};

enum EScenePriority
{
	eScenePriority_Underwater,
	eScenePriority_Water,
	eScenePriority_OnWater,
	eScenePriority_Ground,
	eScenePriority_OnGround,
	eScenePriority_Background,
	eScenePriority_Normal,
	eScenePriority_Foreground,
	eScenePriority_Flying,
	eScenePriority_InHand,
	eScenePriority_UserInterface
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CSceneManager
{
private:

	//class structures
	struct SElement
	{
		ESceneElement	m_eType;
		int				m_iRef;
		int				m_iSortIndex;
	};

	//class data
	SElement			m_sElement[SceneManager_c_iMaxElements];
	int					m_iNumElements;

	ldwPoint			m_sBasePos;
	float				m_fScale;
	int					m_iScale;

	//class methods
	//setup
	public:		CSceneManager(void);

	//process
	public:		void BeginScene(const ldwPoint sBasePos = ldwPoint(0, 0), const float fScale = 1.0f);
	public:		void EndScene();

	public:		void AddElement(const ESceneElement eType, const int iRef, const EScenePriority eScenePriority, const int iOffset = 0);

	public:		void Draw(ldwImage *pImage, const ldwPoint sPos, const float fAlpha = 1.0f) const;
	public:		void Draw(ldwImageGrid *pImage, const ldwPoint sPos, const int iFrame, const float fAlpha = 1.0f) const;
	public:		void DrawScaled(ldwImage *pImage, const ldwPoint sPos, const float fScale, const bool bScaleRelative = false) const;
	public:		void DrawScaled(ldwImageGrid *pImage, const ldwPoint sPos, const int iRow, const int iColumn, const float fScale) const;

	//access
	public:		const ldwPoint BasePos() const { return m_sBasePos; }
	public:		const float Scale() const { return m_fScale; }
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CSceneManager		SceneManager;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/